/*
 *  Copyright (C) 2016 Zoltan Hudak
 *  hudakz@outlook.com
 *
 *  Parts Copyright (C) Libelium Comunicaciones Distribuidas S.L.
 *  http://www.libelium.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  Version 1.0
 */
#include "Thread.h"
/*$off*/

pthread_t  idThread2;
pthread_t  idThread3;
pthread_t  idThread4;
pthread_t  idThread5;
pthread_t  idThread6;
pthread_t  idThread7;
pthread_t  idThread8;
pthread_t  idThread9;
pthread_t  idThread10;
pthread_t  idThread11;
pthread_t  idThread12;
pthread_t  idThread13;
pthread_t  idThread14;
pthread_t  idThread15;
pthread_t  idThread16;
pthread_t  idThread17;
pthread_t  idThread18;
pthread_t  idThread19;
pthread_t  idThread20;
pthread_t  idThread21;
pthread_t  idThread22;
pthread_t  idThread23;
pthread_t  idThread24;
pthread_t  idThread25;
pthread_t  idThread26;
pthread_t  idThread27;

pthread_t*   idThreads[26] =
{
   &idThread2,
   &idThread3,
   &idThread4,
   &idThread5,
   &idThread6,
   &idThread7,
   &idThread8,
   &idThread9,
   &idThread10,
   &idThread11,
   &idThread12,
   &idThread13,
   &idThread14,
   &idThread15,
   &idThread16,
   &idThread17,
   &idThread18,
   &idThread19,
   &idThread20,
   &idThread21,
   &idThread22,
   &idThread23,
   &idThread24,
   &idThread25,
   &idThread26,
   &idThread27
};

/*$on*/

/* This is the function that will be running in a thread if
 * attachInterrupt() is called */
void* threadFunction(void* args)
{
    ThreadArg*      arguments = (ThreadArg*)args;
    int             pin = arguments->pin;

    int             GPIO_FN_MAXLEN = 32;
    int             RDBUF_LEN = 5;

    char            fn[GPIO_FN_MAXLEN];
    int             fd, ret;
    struct pollfd   pfd;
    char            rdbuf[RDBUF_LEN];

    memset(rdbuf, 0x00, RDBUF_LEN);
    memset(fn, 0x00, GPIO_FN_MAXLEN);

    snprintf(fn, GPIO_FN_MAXLEN - 1, "/sys/class/gpio/gpio%d/value", pin);
    fd = open(fn, O_RDONLY);
    if (fd < 0) {
        perror(fn);
        exit(1);
    }

    pfd.fd = fd;
    pfd.events = POLLPRI;

    ret = unistd::read(fd, rdbuf, RDBUF_LEN - 1);
    if (ret < 0) {
        perror("Error reading interrupt file\n");
        exit(1);
    }

    while (1) {
        memset(rdbuf, 0x00, RDBUF_LEN);
        unistd::lseek(fd, 0, SEEK_SET);
        ret = poll(&pfd, 1, -1);
        if (ret < 0) {
            perror("Error waiting for interrupt\n");
            unistd::close(fd);
            exit(1);
        }

        if (ret == 0) {
            printf("Timeout\n");
            continue;
        }

        ret = unistd::read(fd, rdbuf, RDBUF_LEN - 1);
        if (ret < 0) {
            perror("Error reading interrupt file\n");
            exit(1);
        }

        //Interrupt. We call user function.
        arguments->func();
    }
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
pthread_t* getThreadIdFromPin(int pin)
{
    int i = pin - 2;
    if ((0 <= i) && (i <= 25))
        return idThreads[i];
    else return NULL;
}
