#ifndef _I2C_H_
#define _I2C_H_

#include "BCM2835.h"

class   I2C
{
public:
    I2C();
    ~I2C();
    uint8_t read(uint8_t address, char* buf, int len, bool repeat = false);
    uint8_t read(bool ack = true);
    int     write(uint8_t address, const char* buf, int len, bool repeat = false);
    int     write(uint8_t data);
private:
    int     _memfd;
    int     _i2c_byte_wait_us;
    int     _i2c_bytes_to_read;
    uint8_t _addr;

    void    setAddress(uint8_t address);
    void    requestFrom(unsigned char address, int len);
    uint8_t read(char* buf);
    uint8_t read_repeat(char* buf, int len);
    int     write(const char* buf, int len);
    int     map_peripheral(struct bcm2835_peripheral* p);
    void    unmap_peripheral(struct bcm2835_peripheral* p);
    void    wait_i2c_done();
};

#endif	// _I2C_H_

