#ifndef _DIGITAL_IN_OUT_H_
#define _DIGITAL_IN_OUT_H_

#include "BCM2835.h"

class   DigitalInOut
{
public:
    DigitalInOut(PinName pin) :
    gpio(pin)
    {
        gpio_dir(gpio, PIN_INPUT);
        gpio_write(gpio, LOW);
    }

    DigitalInOut(PinName pin, PinDirection direction, PinMode mode, int value) :
    gpio(pin)
    {
        if (direction == PIN_INPUT) {
            gpio_dir(gpio, PIN_INPUT);
            if (mode == PullUp)
                gpio_write(gpio, HIGH);
            else
                gpio_write(gpio, LOW);
        }
        else {
            gpio_dir(gpio, PIN_OUTPUT);
            gpio_write(gpio, value);
        }
    }

    void                    write(int value)    { gpio_write(gpio, value); }
    int                     read()              { return gpio_read(gpio); }
    void                    output()            { gpio_dir(gpio, PIN_OUTPUT); }
    void                    input()             { gpio_dir(gpio, PIN_INPUT); }
    DigitalInOut &operator  =(int value)        { write(value); return *this; }
    operator int()                              { return read(); }
protected:
    PinName gpio;
};

#endif	// _DIGITAL_IN_OUT_H_

