#include "ThisThread.h"

namespace ThisThread{

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void sleep_for_s(float s)
{
    unistd::usleep(s * 1000 * 1000);
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void sleep_for_ms(uint32_t ms)
{
    unistd::usleep(ms * 1000);
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void sleep_for_us(uint32_t us)
{
    if (us < 100) {
        struct timespec tim, tim2;
        tim.tv_sec = 0;
        tim.tv_nsec = us * 1000;

        if (nanosleep(&tim, &tim2) < 0) {
            fprintf(stderr, "Nano sleep system call failed \n");
            exit(1);
        }
    }
    else {
        struct timeval  tNow, tLong, tEnd;

        gettimeofday(&tNow, NULL);
        tLong.tv_sec = us / 1000000;
        tLong.tv_usec = us % 1000000;
        timeradd(&tNow, &tLong, &tEnd);

        while (timercmp(&tNow, &tEnd, < ))
            gettimeofday(&tNow, NULL);
    }
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void sleep_for(uint32_t ms) {
    sleep_for_ms(ms);
}

}
