var Process = require("qbs.Process");
var File = require("qbs.File");

function findCommand(){
    // check if it's unix
    if(File.exists("/usr/bin/find")){
        return "/usr/bin/find";
    }

    // else msys2, search unix find command
    var where = new Process();
    where.exec("where.exe", ['find'], true);
    if(where.exitCode()!==0){
        throw("error: There is a problem to detect the 'find' command."+where.exitCode());
    }

    while(true){
        var line = where.readLine();
        if(line!=="" && line!==undefined){
            var findPos = line.indexOf("bin\\find.exe");
            if (findPos > -1){
                return line;
            }
        }else{
            break;
        }
    }
    where.close()
    return "find";
}

function dirs(dir){
    var ret = []
    if(!File.exists(dir)){
        return ret;
    }
    var find = new Process();
    var params = [dir,'-type','d'];
    find.exec(findCommand(), params)
    if(find.exitCode()!==0){
        var error = find.readStdErr();
        throw("error: " + error)
    }
    var line = find.readLine();
    while(line.trim()!==""){
        ret = ret.concat([line.trim()]);
        line = find.readLine();
    }
    find.close();
    return(ret)
}

function getTimes() {
    var d = new Date()
    var current = d.getTime()/1000 // To seconds
    var timezone = d.getTimezoneOffset()*60 // To seconds
    var daylight = 0

    return {"utc":current.toFixed(),
        "local":(current+timezone+daylight).toFixed(),
        "zone":timezone.toFixed(),
        "dst":daylight.toFixed()}
}


