#ifndef _SERIAL_H_
#define _SERIAL_H_

#include "BCM2835.h"

class   Serial
{
public:
    Serial();
    void    baud(int serialSpeed);
    int     readable();
    char    read();
    int     readBytes(char message[], int size);
    int     readBytesUntil(char character, char buffer[], int length);
    bool    find(const char* target);
    bool    findUntil(const char* target, const char* terminal);
    long    parseInt();
    float   parseFloat();
    char    peek();
    void    printf(const char* format, ...);
    int     write(uint8_t message);
    int     write(const char* message);
    int     write(char* message, int size);
    void    flush();
    void    setTimeout(long millis);
    void    close();
private:
    int             sd, status;
    const char*     serialPort;
    unsigned char   c;
    struct termios  options;
    int             speed;
    long            timeOut;
    timespec        time1, time2;
    timespec        timeDiff(timespec start, timespec close);
    char*           int2bin(int i);
    char*           int2hex(int i);
    char*           int2oct(int i);
};

#endif	// _SERIAL_H_

