#ifndef _PIN_NAMES_H_
#define _PIN_NAMES_H_

typedef enum {
    // Not connected
    NC = (int)0xFFFFFFFF,

    // GPIO names
    gpio2       = 2,
    gpio3       = 3,
    gpio4       = 4,
    gpio5       = 5,
    gpio6       = 6,
    gpio7       = 7,
    gpio8       = 8,
    gpio9       = 9,
    gpio10      = 10,
    gpio11      = 11,
    gpio12      = 12,
    gpio13      = 13,
    gpio14      = 14,
    gpio15      = 15,
    gpio16      = 16,
    gpio17      = 17,
    gpio18      = 18,
    gpio19      = 19,
    gpio20      = 20,
    gpio21      = 21,
    gpio22      = 22,
    gpio23      = 23,
    gpio24      = 24,
    gpio25      = 25,
    gpio26      = 26,
    gpio27      = 27,

    // Rapsberry Pi pin names
    p3          = gpio2,
    p5          = gpio3,
    p7          = gpio4,
    p8          = gpio14,
    p10         = gpio15,
    p11         = gpio17,
    p12         = gpio18,
    p13         = gpio27,
    p15         = gpio22,
    p16         = gpio23,
    p18         = gpio24,
    p19         = gpio10,
    p21         = gpio9,
    p22         = gpio25,
    p23         = gpio11,
    p24         = gpio8,
    p26         = gpio7,
    p29         = gpio5,
    p31         = gpio6,
    p32         = gpio12,
    p33         = gpio13,
    p35         = gpio19,
    p36         = gpio16,
    p37         = gpio26,
    p38         = gpio20,
    p40         = gpio21,

    // Extension board V2.1 pin names
    P0          = gpio17,
    P1          = gpio18,
    P2          = gpio27,
    P3          = gpio22,
    P4          = gpio23,
    P5          = gpio24,
    P6          = gpio25,
    P7          = gpio4,
    CE1         = gpio7,
    CE0         = gpio8,
    CS          = gpio8,
    SCLK        = gpio11,
    MISO        = gpio9,
    MOSI        = gpio10,
    RXD         = gpio15,
    TXD         = gpio14,
    SCL         = gpio3,
    SDA         = gpio2,
    PWM         = gpio18,

    // Arduino pin names on the Extension board V2.1
    D2          = gpio18,
    D3          = gpio23,
    D4          = gpio24,
    D5          = gpio25,
    D6          = gpio4,
    D7          = gpio17,
    D8          = gpio27,
    D9          = gpio22
} PinName;

typedef enum
{
    PIN_INPUT,
    PIN_OUTPUT
} PinDirection;

typedef enum
{
    PullNone,
    PullUp,
    PullDown,
    OpenDrain,
    PullDefault = PullNone
} PinMode;

#endif	// _PIN_NAMES_H_
