import qbs
import qbs.Process
import qbs.File
import qbs.FileInfo
import qbs.TextFile
import "/home/zoli/.config/QtProject/qtcreator/templates/wizards/qbs_rpi/js/helpers.js" as helpers

CppApplication {
    type: "application"
    consoleApplication: true
    Depends { name: "cpp" }
//    cpp.cppFlags: "-std=c++11"
//    Depends {
//        name: "Qt";
//        submodules: ["core", "gui", "widgets"]
//    }

    Group {
        fileTagsFilter: product.type
        qbs.install: true
        qbs.installDir: "bin"
        qbs.installPrefix: "/mnt/workbench"
    }

    property string     sysPath: "/home/zoli/src/rpi/sys"
    property stringList sys: [
        "drivers",
    ]
    property pathList   sysPaths: {
        var l = []
        for (var i = 0; i < sys.length; i++) {
            l = l.concat(helpers.dirs(sysPath+"/"+sys[i]))
        }
        return l
    }

    Group {
        name: "sys"
        condition: (sysPath != "")
        files: {
            var l = []
            for (var i = 0; i < sys.length; i++) {
//                l = l.concat(sys[i]+"/**")
                l = l.concat(sys[i]+"/**/*.cpp")
                l = l.concat(sys[i]+"/**/*.c")
                l = l.concat(sys[i]+"/**/*.hpp")
                l = l.concat(sys[i]+"/**/*.h")
                l = l.concat(sys[i]+"/**/*.s")
            }
            return l
        }
        prefix: sysPath + "/"
    }

    property string     libPath: "/home/zoli/src/rpi/lib"
    property stringList libs: []
    property pathList   libPaths: {
        var l = []
        for (var i = 0; i < libs.length; i++) {
            l = l.concat(helpers.dirs(libPath+"/"+libs[i]))
        }
        return l
    }

    Group {
        name: "libs"
        condition: (libPath != "")
        files: {
            var l = []
            for (var i = 0; i < libs.length; i++) {
//                l = l.concat(libs[i]+"/**")
                l = l.concat(libs[i]+"/**/*.cpp")
                l = l.concat(libs[i]+"/**/*.c")
                l = l.concat(libs[i]+"/**/*.hpp")
                l = l.concat(libs[i]+"/**/*.h")
                l = l.concat(libs[i]+"/**/*.s")
            }
            return l
        }
        prefix: libPath + "/"
    }

    property pathList includePaths: ""

    cpp.compilerIncludePaths: "/home/zoli/toolchain/rpi/arm-bcm2708/arm-bcm2708-linux-gnueabi/arm-bcm2708-linux-gnueabi/include/c++/4.7.1"
    cpp.compilerFrameworkPaths: "/home/zoli/toolchain/rpi/arm-bcm2708/arm-bcm2708-linux-gnueabi/bin/"
    cpp.compilerLibraryPaths: "/home/zoli/toolchain/rpi/arm-bcm2708/arm-bcm2708-linux-gnueabi/arm-bcm2708-linux-gnueabi/lib"
    cpp.includePaths: includePaths.concat("/.", sysPaths, libPath)
   //cpp.staticLibraries: ["mbed"]
    cpp.dynamicLibraries: ["rt", "pthread"]
}


