#ifndef _DIGITAL_OUT_H_
#define _DIGITAL_OUT_H_

#include "BCM2835.h"

class   DigitalOut
{
public:
    DigitalOut(PinName pin) :
    gpio(pin)
    {
        gpio_dir(gpio, PIN_OUTPUT);
        gpio_write(gpio, LOW);
    }

    DigitalOut(PinName pin, PinMode mode, int value) :
    gpio(pin)
    {
        gpio_dir(gpio, PIN_OUTPUT);
        gpio_write(gpio, value);
    }

    void                    write(int value)    { gpio_write(gpio, value); }
    int                     read()              { return gpio_read(gpio); }
    void                    output()            { gpio_dir(gpio, PIN_OUTPUT); }
    DigitalOut &operator  =(int value)          { write(value); return *this; }
    operator int()                              { return read(); }
protected:
    PinName gpio;
};

#endif	// _DIGITALOUT_H_

