#include "BCM2835.h"

extern volatile uint32_t*   bcm2835_st;
extern volatile timeval     start_program;

/**
 * @brief   Reads the System Timer Counter (64-bits)
 * @note
 * @param
 * @retval
 */
uint64_t bcm2835_systimer_read(void)
{
    volatile uint32_t* paddr;
    uint32_t hi, lo;
    uint64_t st;

    if (bcm2835_st==MAP_FAILED) {
        return 0;
    }

    paddr = bcm2835_st + BCM2835_ST_CHI/4;
    hi = bcm2835_peri_read(paddr);

    paddr = bcm2835_st + BCM2835_ST_CLO/4;
    lo = bcm2835_peri_read(paddr);

    paddr = bcm2835_st + BCM2835_ST_CHI/4;
    st = bcm2835_peri_read(paddr);

    /* Test for overflow */
    if (st == hi)
    {
        st <<= 32;
        st += lo;
    }
    else
    {
        st <<= 32;
        paddr = bcm2835_st + BCM2835_ST_CLO/4;
        st += bcm2835_peri_read(paddr);
    }
    return st;
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
uint64_t us_ticker_read()
{
    struct timeval  end_point;
    uint64_t        elapsedTime;

    // stop timer

    gettimeofday(&end_point, NULL);

    // compute and print the elapsed time in microseconds
    //elapsedTime = (end_point.tv_sec - start_program.tv_sec) * 1000000.0;   // sec to us
    elapsedTime += (end_point.tv_usec - start_program.tv_usec);
    return elapsedTime;
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void bcm2835_sleep_for_ms(unsigned int millis)
{
    struct timespec sleeper;

    sleeper.tv_sec = (time_t) (millis / 1000);
    sleeper.tv_nsec = (long)(millis % 1000) * 1000000;
    nanosleep(&sleeper, NULL);
}
