#ifndef _INTERRUPT_IN_H_
#define _INTERRUPT_IN_H_

#include "BCM2835.h"
#include "PinNames.h"
#include "DigitalIn.h"

class   InterruptIn
{
public:
    InterruptIn(PinName pin) :
    _digitalIn(pin)
    { }

    void    rise(FunctionPointer fptr)  { _digitalIn.attach(fptr, RISING); }
    void    fall(FunctionPointer fptr)  { _digitalIn.attach(fptr, FALLING); }
    void    both(FunctionPointer fptr)  { _digitalIn.attach(fptr, BOTH); }
    int     read()                      { return _digitalIn.read(); }
    void    mode(PinMode mode)          { _digitalIn.mode(mode); }
    operator int()                      { return _digitalIn.read(); }
protected:
    DigitalIn   _digitalIn;
};

#endif	// _INTERRUPT_IN_H_

