#ifndef _DIGITAL_IN_H_
#define _DIGITAL_IN_H_

#include "BCM2835.h"

class   DigitalIn
{
public:
    DigitalIn(PinName pin) :
    gpio(pin)
    {
        gpio_dir(gpio, PIN_INPUT);
        gpio_write(gpio, LOW);
    }

    DigitalIn(PinName pin, PinMode mode) :
    gpio(pin)
    {
        gpio_dir(gpio, PIN_INPUT);
        gpio_mode(pin, mode);
    }

    int     read()                                      { return gpio_read(gpio); }
    void    mode(PinMode mode)                          { mode == PullUp ? gpio_write(gpio, HIGH) : gpio_write(gpio, LOW); }
    void    attach(FunctionPointer fptr, Digivalue m)   { attachInterrupt(gpio, fptr, m); }
    operator int()                                      { return read(); }
protected:
    PinName gpio;
};

#endif	// _DIGITAL_IN_H_

