# Bluepill board support for Mbed OS 6

This is an example of configuration for the [Bluepill](https://os.mbed.com/users/hudakz/code/STM32F103C8T6_Hello/) board for the upcoming version of Mbed OS 6 (beta at this time).

It shows how to create a custom board support based on Mbed OS and how to compile a simple Blinky application.

Note this project makes use of the full Mbed OS with RTOS included. It's possible to make changes in the configuration to support the Baremetal profile and reduce memory requirements - see [this](https://os.mbed.com/docs/mbed-os/v5.15/reference/mbed-os-bare-metal.html).

### Example application

This repository includes `blinky.cpp` as an example application to demonstrate how to use the Bluepill custom board support. It's expected to work out of the box using both Mbed CLI and Mbed Studio.

Note this test application can be ignored using the `MBED_BLINKY_EXAMPLE` macro in `mbed_app.json`, so you can add your own files and application on top of this project.

You can follow these steps to import and compile with Mbed CLI:

```
$ mbed import https://github.com/MarceloSalazar/mbed-os-bluepill
$ mbed compile -t GCC_ARM -m bluepill
```

### Bluepill and Mbed OS version support

| Bluepill          | Mbed OS  (hash)                           | Status              |
| ----------------- | ----------------------------------------- | ------------------- |
| preview           | beta ([#1b2a68ae](https://github.com/ARMmbed/mbed-os/#1b2a68ae204b70a7aaf3818dc8fa3881250b13b0))                     | Compiles and runs ok         |

### Updating Mbed OS

Note not every version of Mbed OS is being tested, therefore update at your own risk.
Unless strictly required, you should stick to versions of Mbed OS that are known to work ok.

If you do want to udpate Mbed OS, then follow these steps:

```
cd mbed-os
mbed update <mbed-os hash / tag>
```

### Testing

This application has been tested on the Bluepill board and runs ok: it blinks and LED and sends a message over the serial port (115200 bauds - see `mbed_app.json`).

However, it's recomended to run regression tests based on the [Greentea](https://os.mbed.com/docs/mbed-os/latest/tools/greentea-testing-applications.html) framework whether possible (more details to be added).

### Programming with STLink programming utility

The Bluepill board doesn't have a programming interface on board. However, it's easy to connect an external adapter such as the [STLink/V2](https://www.st.com/en/development-tools/st-link-v2.html) and get it working in minutes.

Use the [STM32 ST-Link utility](https://www.st.com/en/development-tools/stsw-link004.html) to program the binary into the device.

![STLink](/img/stlink-prog.png)

Wire the Bluepill to the STLink and serial adapter as follow:

| Bluepill      | STLink (20-pin JTAG)  | Serial adapter   |
| ------------- | ----------------------|------------------|
| RESET         | 15                    |-   |
| SDWIO (CN4)   | 7                     |-   |
| SWCLK (CN4)   | 9                     |-   |
| GND           | 15                    |GND |
| TX (PA_2)     | -                     |RX  |
| RX (PA_3)     | -                     |TX  |

The standard JTAG pintout can be seen [here](http://www.keil.com/support/man/docs/ulinkpro/ulinkpro_hw_if_jtag20.htm)

This is the pinout of the Bluepill board:
![Board-pinout](https://os.mbed.com/media/uploads/hudakz/stm32f103c8t6_pinout_voltage01.png)

![HW-connections](/img/connections.jpg)

### Known issues

- Please check [issues](https://github.com/MarceloSalazar/mbed-os-bluepill/issues) reported on GitHub. 

