/*
 * UIPEthernet UdpServer example.
 *
 * UIPEthernet is a TCP/IP stack that can be used with an enc28j60 based
 * Ethernet-shield.
 *
 * UIPEthernet uses the fine uIP stack by Adam Dunkels <adam@sics.se>
 *
 *      -----------------
 *
 * This UdpServer example sets up a udp-server for testing.
 *
 * Copyright (C) 2013 by Norbert Truchsess (norbert.truchsess@t-online.de)
 *
 * Modified (ported to mbed) by Zoltan Hudak
 *
 */
#include "mbed.h"
#include "UipEthernet.h"

#define IP      "192.168.1.35"
#define GATEWAY "192.168.1.1"
#define NETMASK "255.255.255.0"
#define PORT    80

// MAC address must be unique within the connected network. Modify as appropriate.
const uint8_t   MAC[6] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05 };
UipEthernet     net(MAC, D11, D12, D13, D10);   // mac, mosi, miso, sck, cs

const char      message[] = "Hello World from mbed!";


/**
 * @brief
 * @note
 * @param
 * @retval
 */
int main(void) {
    // Bring up the ethernet interface
    //net.set_network(IP, NETMASK, GATEWAY);  // include this for using static IP address
    printf("UDP Server example\n");
    if(net.connect() != 0) {
        printf("Error connecting\n");
        return -1;
    }

    // Show the network address
    const char*     ip = net.get_ip_address();
    const char*     netmask = net.get_netmask();
    const char*     gateway = net.get_gateway();

    printf("IP address: %s\r\n", ip ? ip : "None");
    printf("Netmask: %s\r\n", netmask ? netmask : "None");
    printf("Gateway: %s\r\n\r\n", gateway ? gateway : "None");

    UdpSocket       socket(&net);

    socket.begin(PORT); // listen at port PORT for user datagrams

    printf("Waiting for datagrams from UDP clients ...\r\n\r\n");

    while (1) {
        int success;
        int size = socket.parsePacket();

        if (size > 0) {
            IpAddress remoteIp = socket.remoteIP();
            char remoteAddr[16];
            do {
                char*   data = (char*)malloc(size + 1);
                int     len = socket.read(data, size + 1);
                data[len] = 0;
                printf("data received from %s: \r\n%s", remoteIp.toString(remoteAddr), data);
                free(data);
            } while ((size = socket.available()) > 0);

            //finish reading this packet:
            socket.flush();
            printf("\r\n");

            do {
                //send new packet back to ip/port of client. This also
                //configures the current connection to ignore packets from
                //other clients!
                success = socket.beginPacket(socket.remoteIP(), socket.remotePort());
                if (success)
                    printf("beginPacket: succeeded\r\n");
                else
                    printf("beginPacket: failed\r\n");

                //beginPacket fails if remote ethaddr is unknown. In this case an
                //arp-request is send out first and beginPacket succeeds as soon
                //the arp-response is received.
            } while (!success);

            success = socket.write((uint8_t*)message, strlen(message));

            if (success)
                printf("bytes written: %d\r\n", success);

            success = socket.endPacket();

            if (success)
                printf("endPacket: succeeded\r\n");
            else
                printf("endPacket: failed\r\n");

            socket.close();

            //restart with new connection to receive packets from other clients
            if (socket.begin(PORT))
                printf("restart connection: succeeded\r\n");
            else
                printf("restart connection: failed\r\n");
        }
    }
}
