/*
 * -------
 *        |
 * KL25Z  |
 *        |
 *        |
 *   PTD3 |-------
 *        |       |
 * -------        |
 *                o
 *                 /
 *                o
 *                |
 *               ---
 *               GND
 */

#include "mbed.h"
#include "USBKeyboard.h"

#define BOUNCING_TIME   300*1000    // 300 ms

USBKeyboard key;
InterruptIn startMP3Player(PTD3, PullUp);
Thread      t;
EventQueue  queue;
Timeout     btnDebouncer;
bool        btnIsBouncing = false;

void bouncingOver(void)
{
    btnIsBouncing = false;
}

void startMP3Player_handler(void)
{
    if (btnIsBouncing == false) {
        key.printf("vlc windofchange.mp3\n");  // replace this text with the command to play an MP3 file (but keep \n)
        btnDebouncer.attach_us(bouncingOver, BOUNCING_TIME);
        btnIsBouncing = true;
    }
}

int main(void)
{
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    startMP3Player.fall(queue.event(startMP3Player_handler));
}
