/*
 * Simple TcpServer using the UIPEthernet library for ENC28J60 Ethernet boards.
 *
 */
#include "mbed.h"
#include "UipEthernet.h"
#include "TcpServer.h"
#include "TcpClient.h"

#define IP      "192.168.1.35"
#define GATEWAY "192.168.1.1"
#define NETMASK "255.255.255.0"
#define PORT    80

const uint8_t   MAC[6] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05 };
UipEthernet     net(MAC, D11, D12, D13, D10);   // mac, mosi, miso, sck, cs
TcpServer       server;                         // Ethernet server
TcpClient*      client;
uint8_t         recvData[1024];
const char      sendData[] = "Data received OK";

/**
 * @brief
 * @note
 * @param
 * @retval
 */
int main(void)
{
    printf("Starting ...\r\n");

    //net.set_network(IP, NETMASK, GATEWAY);  // include this to use static IP address
    net.connect();

    // Show the network address
    const char*     ip = net.get_ip_address();
    const char*     netmask = net.get_netmask();
    const char*     gateway = net.get_gateway();

    printf("IP address: %s\r\n", ip ? ip : "None");
    printf("Netmask: %s\r\n", netmask ? netmask : "None");
    printf("Gateway: %s\r\n\r\n", gateway ? gateway : "None");

    /* Open the server on ethernet stack */
    server.open(&net);

    /* Bind the HTTP port (TCP 80) to the server */
    server.bind(PORT);

    /* Can handle 4 simultaneous connections */
    server.listen(4);

    while (true) {
        client = server.accept();

        if (client) {
            size_t  recvLen;

            printf("\r\n----------------------------------\r\n");
            printf("Client with IP address %s connected.\n\r", client->getpeername());
            if ((recvLen = client->available()) > 0) {
                printf("%d bytes received:\r\n", recvLen);
                client->recv(recvData, recvLen);
                for (int i = 0; i < recvLen; i++)
                    printf(" 0x%.2X", recvData[i]);
                printf("\r\n");
                client->send((uint8_t*)sendData, strlen(sendData));
                printf("%s\r\n", sendData);
            }

            printf("Client with IP address %s disconnected.\r\n", client->getpeername());
            client->close();
        }
    }
}
