#include "mbed.h"
#include "TLE5012B.h"
//

using namespace TLE5012;

DigitalOut      led1(PC_13);
TLE5012B_SPI    tle5012b_spi(D11, D12, D13);    // mosi, miso, sck (spi connections to be shared by all devices)
TLE5012B        tle5012b(&tle5012b_spi, D10);   // shared spi bus, cs of this device
errorTypes      checkError = NO_ERROR;
Ticker          ticker;
volatile bool   tick = false;

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void onTick()
{
    tick = true;
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
int main()
{
    int16_t aRaw = 0;
    int16_t sRaw = 0;
    int16_t tRaw = 0;

    double  a = 0.0;
    int16_t b = 0;
    double  r = 0.0;
    double  s = 0.0;
    double  t = 0.0;
    //

    checkError = tle5012b.begin(TLE5012B_S0);
    printf("\r\n");
    printf("checkError:\t%d\r\n", checkError);
#if MBED_MAJOR_VERSION < 6
    wait(1);
#else
    ThisThread::sleep_for(1s);
#endif
    printf("Init done\r\n");

    ticker.attach_us(onTick, 500 * 1000);   // 500ms

    while (1) {
        if (tick) {
            tick = false;
            led1 = !led1;
            tle5012b.getAngleValue(a, aRaw, UPD_LOW, SAFE_LOW);
            tle5012b.getNumRevolutions(b, UPD_LOW, SAFE_LOW);
            tle5012b.getAngleRange(r);
            tle5012b.getAngleSpeed(s, sRaw, UPD_LOW, SAFE_LOW);
            tle5012b.getTemperature(t, tRaw, UPD_LOW, SAFE_LOW);
            printf("Angle:\t\t%f°\r\n", a);
            printf("Revolution:\t%i\r\n", b);
            printf("Range:\t\t%f\r\n", r);
            printf("Speed:\t\t%f\r\n", s);
            printf("Temperature:\t%f°C\r\n", t);
            printf("----------------------\r\n");
        }
    }
}
