#include "DcMotor.h"

/**
 * @brief   The DcMotor class
 * @note    Driven by L293 or L298
 */
DcMotor::DcMotor(PinName pin1, PinName pin2, int driverType) :
    _driverType(driverType)
{
    _pwmOut1 = new PwmOut(pin1);
    _pwmOut1->write(0);
    switch (_driverType) {
        case 0: //L293
            _pwmOut2 = new PwmOut(pin2);
            _pwmOut2->write(0);
            break;

        case 1: //L297
            _digitalOut2 = new DigitalOut(pin2);
            _digitalOut2->write(0);
            break;
    }
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
DcMotor::~DcMotor()
{
    delete _pwmOut1;
    delete _pwmOut2;
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void DcMotor::run(int direction, float speed)
{
    switch (_driverType) {
        case 0: //L293
            if (direction == 0) {
                _pwmOut1->write(0);
                _pwmOut2->write(speed);
            }
            else {
                _pwmOut1->write(speed);
                _pwmOut2->write(0);
            }
            break;

        case 1: //L297
            if (direction == 0)
                _digitalOut2->write(0);
            else
                _digitalOut2->write(1);

            _pwmOut1->write(speed);
            break;
    }
}
