#ifndef INTRINCOUNTER_H
#define INTRINCOUNTER_H

#include "mbed.h"

/**
 * @brief   The IntInCounter class
 * @note    Incremented on rising edge of input signal connected to InterruptIn pin
 */
class   IntrInCounter
{
    uint8_t         _value;
    InterruptIn*    _interruptIn;
public:
    IntrInCounter(PinName pin);
    void    inc()                   { _value++; }
    void    reset()                 { _value = 0; }
    uint8_t read()                  { return _value; }
    void    activate(PinName pin)   { }
};
#endif // INTINCOUNTER_H
