#include "Encoder.h"

/**
 * @brief   The Encoder class
 * @note    Rotary encoder with three operating modes
 */
Encoder::Encoder(PinName pinA, PinName pinB, int mode) : _position(0)
{
    switch (mode) {
        case 1:
            _chanA = new InterruptIn(pinA);
            _chanA->rise(callback(this, &Encoder::onRiseMode1));
            _chanB = new InterruptIn(pinB);
            break;

        case 2:
            _chanA = new InterruptIn(pinA);
            _chanA->rise(callback(this, &Encoder::onChangeMode2));
            _chanA->fall(callback(this, &Encoder::onChangeMode2));
            _chanB = new InterruptIn(pinB);
            break;

        case 4:
            _chanA = new InterruptIn(pinA);
            _chanA->rise(callback(this, &Encoder::onChangeMode2));
            _chanA->fall(callback(this, &Encoder::onChangeMode2));
            _chanB = new InterruptIn(pinB);
            _chanB->rise(callback(this, &Encoder::onChangeMode2));
            _chanB->fall(callback(this, &Encoder::onChangeMode2));
            break;
    }
}

Encoder::~Encoder()
{
    delete _chanA;
    delete _chanB;
}

void Encoder::onRiseMode1()
{
    int b = _chanB->read();
    if (b)
        _position--;
    else
        _position++;
}
void Encoder::onChangeMode2()
{
    int a = _chanA->read();
    int b = _chanB->read();
    if ((a && !b) || (!a && b))
        _position++;
    else
        _position--;
}
void Encoder::onChangeMode4()
{
    int a = _chanA->read();
    int b = _chanB->read();
    if ((a && !b) || (!a && b))
        _position++;
    else
        _position--;
}
