#ifndef SCILABSERIAL_H
#define SCILABSERIAL_H

#include "mbed.h"
#include "Servo.h"
#include "IntrInCounter.h"
#include "Encoder.h"
#include "DcMotor.h"
#include "MPU6050.h"

//#define USBSERIAL
#define RX_MAX  64

#ifdef USBSERIAL
#include "USBSerial.h"
//#include "stm32f103c8t6.h"
#endif
/**
 * @brief   The PcSerial class
 * @note    For serial communication with PC
 */
#ifdef USBSERIAL
class PcSerial :
    public USBSerial
{
public:
    PcSerial() :
    USBSerial(0x1f00, 0x2012, 0x0001, false)
    {
        rxDataLen = 0;
        attach(this, &PcSerial::onRx);
    }

    void onRx()
    {
        memset(rxData, 0, RX_MAX);
        while (available()) {
            char    c = _getc();
            if (c != '\n') {
                if (rxDataLen >= RX_MAX)
                    rxDataLen = 0;  // rxBuf overflow
                rxData[rxDataLen++] = c;
            }
        }
    }

    ssize_t         write(const void* buffer, size_t length)    { return writeBlock((uint8_t*)buffer, length); }
    char            rxData[RX_MAX];
    volatile size_t rxDataLen;
};
#else
class ScilabSerial :
    public SerialBase
{
    bool            _rxComplete;
    char            _rxBuf[RX_MAX];
    volatile size_t _rxBufLen;
    char            _rxData[RX_MAX];
    volatile size_t _rxDataLen;

#if defined(TARGET_BLUEPILL)
    PinName         _digitalPinName[16] = { NC, NC, D2, D3, D4, D5, D6, D7, D8, NC, D10, D11, D12, D13, D14, D15 };
    PinName         _analogPinName[6] = { A0, A1, A2, A3, NC, NC };
#elif defined(TARGET_BLACKPILL)
    PinName         _digitalPinName[16] = { NC, NC, D2, D3, D4, D5, D6, D7, D8, NC, D10, D11, D12, D13, D14, D15 };
    PinName         _analogPinName[6] = { A0, A1, A2, A3, NC, NC };
#else
    PinName         _digitalPinName[16] = { NC, NC, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15 };
    PinName         _analogPinName[6] = { A0, A1, A2, A3, A4, A5 };
#endif
    DigitalInOut*   _digitalInOuts[8];
    AnalogIn*       _analogIns[6];
    PwmOut*         _pwmOuts[4];
    IntrInCounter*  _intrInCounters[8];
    Servo*          _servos[2];
    Encoder*        _encoders[2];
    DcMotor*        _dcMotors[2];
    MPU6050*        _mpu6050;
    Timer           _mpu6050Timer;
    uint32_t        _now;
    float           _deltaT;
    bool            _mpu6050Available;
public:

    ScilabSerial(PinName tx, PinName rx, int baud = 115200);

    void    run();
    void    onRx();
    ssize_t write(const void* buffer, size_t length);
    void    analogRead();
    void    pwmWrite();
    void    digitalReadWrite();
    void    servo();
    void    mpu6050();
    void    intrInCounter();
    void    encoder();
    void    dcMotorInit();
    void    dcMotor();
    void    revision();
    void    mpu6050UpdateData();
};
#endif
#endif // SCILABSERIAL_H
