#include "mbed.h"
#include "RF24.h"

const uint64_t  ADDRESS = 0xF0F0F0F0F0F0F001L;

DigitalOut      led(PA_6);
RF24            radio(PB_5, PB_4, PB_3, PB_7, PB_6);    // mosi, miso, sck, csn, ce, (irq not used)
uint8_t         payload;

int main(void)
{
   // Initialize nRF24L01
    if (!radio.begin()) {
        printf("Failed to initialize nRF24L01. Check whether connected.\r\n");
        return -1;  // Exit the program
    }
    radio.setPALevel(RF24_PA_LOW);
    radio.setRetries(5, 15);
    radio.setPayloadSize(sizeof(payload));
    radio.setAutoAck(true);
    radio.openReadingPipe(0, ADDRESS);  // use pipe 0 of this slave to receive messsages and send back auto acknowledge
    radio.startListening();

    while (1) {
        if (radio.available()) {
            radio.read(&payload, sizeof(payload)); // read message and send acknowledge back to the master
            led = payload;
        }
    }
}
