#include "mbed.h"
#include "RF24.h"

const uint64_t  SLAVE_ADDRESS = 0xF0F0F0F0F0F0F001L;    // slave's address

DigitalOut      led(PA_6);                              // LED1
RF24            radio(PB_5, PB_4, PB_3, PB_7, PB_6);    // mosi, miso, sck, csn, ce, (irq not used)
uint8_t         payload;

int main()
{
    // Initialize nRF24L01
    if (!radio.begin()) {
        printf("Failed to initialize nRF24L01. Check whether connected.\r\n");
        return -1;  // Exit the program
    }
    radio.setPALevel(RF24_PA_LOW);
    radio.setRetries(5, 15);
    radio.setPayloadSize(sizeof(payload));
    radio.setAutoAck(true);

    while (1) {
        led = !led;
        payload = led;

        // Send led's status to slave
        radio.stopListening();
        radio.openWritingPipe(SLAVE_ADDRESS);
        if (radio.write(&payload, sizeof(payload))) // send message to slave and get acknowledge
            printf("Message delivery succeeded.\r\n");
        else
            printf("Message delivery failed.\r\n");

        wait(1);
    }
}
