#include "mbed.h"
#include "USBHostMouse.h"

#define LED1    PA_6

DigitalOut  led(LED1);

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void onMouseEvent(uint8_t buttons, int8_t x, int8_t y, int8_t z)
{
    printf("buttons: %d, x: %d, y: %d, z: %d\r\n", buttons, x, y, z);
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
int main()
{
    USBHostMouse    mouse;

    // connect a USB mouse
    if (!mouse.connect()) {
        printf("USB mouse not found.\n");
        return -1;
    }

    printf("Mouse connected\r\n");
    // when connected, attach handler called on mouse event
    mouse.attachEvent(onMouseEvent);

    Timer   t;
    t.start();
    while(1) {
        if (t.read_ms() > 500) {
            led = !led;
            t.reset();
        }

        USBHost::poll();
    }
}
