#include "mbed.h"
#include "USBHostKeyboard.h"

#define LED1    PA_6

DigitalOut  led(LED1);

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void onKeyboardEvent(uint8_t keyCode, uint8_t modifier)
{
    printf("keyCode: %d, modifier: %d\r\n", keyCode, modifier);
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
int main()
{
    USBHostKeyboard    keyboard;

    // connect a USB keyboard
    if (!keyboard.connect()) {
        printf("USB keyboard not found.\n");
        return -1;
    }

    printf("Keyboard connected\r\n");
    // when connected, attach handler called on keyboard event
    keyboard.attach(onKeyboardEvent);

    Timer   t;
    t.start();
    while(1) {
        if (t.read_ms() > 500) {
            led = !led;
            t.reset();
        }

        USBHost::poll();
    }
}
