// Blinky demo for the STM32F407VET6 boards.
// See http://wiki.stm32duino.com/index.php?title=STM32F407.
//
// Use "Seed Arch Max" as target platform for the online compiler.

#include "mbed.h"
#include "EthernetInterface.h"
 
int main() {
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketConnection sock;
    sock.connect("httpbin.org", 80);
    
    char http_cmd[] = "GET /get?helloworld HTTP/1.0\r\n\r\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
      
    sock.close();
    
    eth.disconnect();
    
    while(1) {}
}