#include "mbed.h"
#include "EthernetInterface.h"
#include "FsHandler.h"
#include "HTTPServer.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"

#define DHCP

#ifndef DHCP
    #define IP      "192.168.1.181"
    #define GATEWAY "192.168.1.1"
    #define NETMASK "255.255.255.0"
#endif

#define PORT    80

SDBlockDevice       blockDevice(PC_3, PC_2, PB_10, PC_0);  // mosi, miso, sck, cs
FATFileSystem       fileSystem("local");
EthernetInterface*  net;
HTTPServer          svr;

int main()
{
    printf("Starting.. \r\n\r\n");

    net = new EthernetInterface();

    if (!net) {
        printf("Error! No network inteface found.\n");
        return -1;
    }

    printf("Network interface found\r\n");

    #ifndef DHCP
        net->set_network (IP, NETMASK, GATEWAY);  // to use static IP address
    #endif

    nsapi_size_or_error_t   ret = net->connect();

    if (ret != 0) {
        printf("Error! net->connect() returned: %d\n", ret);
        return ret;
    }


    printf("Mounting file system at /local\r\n");    
    int err = fileSystem.mount(&blockDevice);
    printf("%s\r\n", (err ? "Fail :(" : "OK"));
    if (err) {
        printf("No filesystem found.\r\n");
        error("error: %s (%d)\r\n", strerror(-err), err);
        return err;
    }

    HTTPFsRequestHandler::mount("/local/", "/");
    svr.addHandler<HTTPFsRequestHandler>("/");

    if (!svr.start(80, net)) {
        error("Server not starting !");
        exit(0);
    }

    printf("Polling for client connections.\r\n");

    while(1) {
        svr.poll();
    }

}
