// Blinky demo using threads for the STM32F407VET6 boards.
// See http://wiki.stm32duino.com/index.php?title=STM32F407 for more info.
//
// "Seed Arch Max" is set as target platform for the online compiler.

#include "mbed.h"
#include "rtos.h"
 
DigitalOut  led1(PA_6);
DigitalOut  led2(PA_7);
Thread      thread;
 
void led2_thread() {
    while (true) {
        led2 = !led2;
        Thread::wait(1000);
    }
}
 
int main() {
    thread.start(led2_thread);
    
    while (true) {
        led1 = !led1;
        Thread::wait(500);
    }
}