/* Hello World! for the TextLCD Enhanced Library*/

#include "mbed.h"
#include "TextLCD.h"

// Host PC Communication channels
Serial  pc(PA_2, PA_3);     // tx, rx

// LCD instantiation
TextLCD lcd(PA_8, PA_9, PA_10, PA_11, PA_12, PA_15, TextLCD::LCD16x2);  // 4-bit bus: RS, E, D4, D5, D6, D7
Timer   t;

int main()
{     
    pc.printf("TextLCD Enhanced Test. Columns=%d, Rows=%d\n\r", lcd.columns(), lcd.rows());

    for (int row = 0; row < lcd.rows(); row++) {
        int col = 0;

        pc.printf("MemAddr(Col=%d, Row=%d)=0x%02X\n\r", col, row, lcd.getAddress(col, row));
        
        lcd.putc('0' + row);

        for (col=1; col < lcd.columns() - 1; col++) {
            lcd.putc('*');
        }

        pc.printf("MemAddr(Col=%d, Row=%d)=0x%02X\n\r", col, row, lcd.getAddress(col, row));
        lcd.putc('+');
    }

// Fill screen again and time it
    t.start();

    for (int row=0; row<lcd.rows(); row++) {
        int col=0;

        lcd.putc('0' + row);

        for (col=1; col<lcd.columns()-1; col++) {
            lcd.putc('*');
        }

        lcd.putc('+');
    }
    t.stop();
    pc.printf("All my hard work took %f sec\r\n", t.read());

// Show cursor as blinking character
    lcd.setCursor(TextLCD::CurOff_BlkOn);

// Set and show user defined characters. A maximum of 8 UDCs are supported by the HD44780.
// They are defined by a 5x7 bitpattern.
    lcd.setUDC(0, (char *) udc_0);  // Show |>
    lcd.putc(0);
    lcd.setUDC(1, (char *) udc_1);  // Show <|
    lcd.putc(1);

    pc.printf("Bye now\r\n");
}
