/*
 * Nokia 5110 LCD demo
 */
#include "mbed.h"
#include "N5110.h"
 
N5110 lcd(PA_9, PA_11, PA_12, PA_15, PB_5, PB_3, PA_10);    // VCC, CE, RST, DC, DIN, CLK, LIGHT

int main()
{
    lcd.init();         // first need to initialise display
 
    while(1) {
 
        // these are default settings so not strictly needed
        lcd.normalMode();      // normal colour mode
        lcd.setBrightness(0.5); // put LED backlight on 50%
 
        // can directly print strings at specified co-ordinates
        lcd.printString("Hello, World!",0,0);
 
        char buffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        // so can display a string of a maximum 14 characters in length
        // or create formatted strings - ensure they aren't more than 14 characters long
        int temperature = 27;
        int length = sprintf(buffer,"T = %2d C",temperature); // print formatted data to buffer
        // it is important the format specifier ensures the length will fit in the buffer
        if (length <= 14)  // if string will fit on display
            lcd.printString(buffer,0,1);           // display on screen
 
        float pressure = 1012.3;  // same idea with floats
        length = sprintf(buffer,"P = %.2f mb",pressure);
        if (length <= 14)
            lcd.printString(buffer,0,2);
 
        // can also print individual characters at specified place
        lcd.printChar('X',5,3);
 
        // draw a line across the display at y = 40 pixels (origin top-left)
        for (int i = 0; i < WIDTH; i++) {
            lcd.setPixel(i,40);
        }
        // need to refresh display after setting pixels
        lcd.refresh();
 
        // can also check status of pixels using getPixel(x,y)
 
        wait(5.0);
        lcd.clear();            // clear display
        lcd.inverseMode();      // invert colours
        lcd.setBrightness(1.0); // put LED backlight on full
 
        float array[84];
 
        for (int i = 0; i < 84; i++) {
            array[i] = 0.5 + 0.5*sin(i*2*3.14/84);
        }
 
        // can also plot graphs - 84 elements only
        // values must be in range 0.0 - 1.0
        lcd.plotArray(array);
        wait(5.0);
        lcd.clear();
        lcd.normalMode();      // normal colour mode back
        lcd.setBrightness(0.5); // put LED backlight on 50%
 
        // example of drawing lines
        for (int x = 0; x < WIDTH ; x+=10) {
            // x0,y0,x1,y1,type 0-white,1-black,2-dotted
            lcd.drawLine(0,0,x,HEIGHT,2);
        }
        lcd.refresh();   // need to refresh screen after drawing lines
 
        wait(5.0);
        lcd.clear();
 
        // example of how to draw circles
        lcd.drawCircle(WIDTH/2,HEIGHT/2,20,FILL_BLACK);  // x,y,radius,black fill
        lcd.drawCircle(WIDTH/2,HEIGHT/2,10,FILL_WHITE);  // x,y,radius,white fill
        lcd.drawCircle(WIDTH/2,HEIGHT/2,30,FILL_TRANSPARENT);  // x,y,radius,transparent with outline
        lcd.refresh();   // need to refresh screen after drawing circles
 
        wait(5.0);
        lcd.clear();
 
        // example of how to draw rectangles
        //          origin x,y,width,height,type
        lcd.drawRect(10,10,50,30,FILL_BLACK);  // filled black rectangle
        lcd.drawRect(15,15,20,10,FILL_WHITE);  // filled white rectange (no outline)
        lcd.drawRect(2,2,70,40,FILL_TRANSPARENT);    // transparent, just outline
        lcd.refresh();   // need to refresh screen after drawing rects
  
        wait(5.0);
        lcd.clear();
    }
}
