/*
 * DS1820 sensor demo
 *
 * Note: Don't forget to connect a 4.7k Ohm resistor 
 *       between the DS1820's data pin and the +3.3V pin
 *
 */
#include "mbed.h"
#include "DS1820.h"
  
Serial      pc(PA_2, PA_3);
DigitalOut  led(PC_13);   
DS1820      ds1820(PA_9);    // substitute PA_9 with actual mbed pin name connected to the DS1820 data pin                             
float       temp = 0;

int main() 
{                          
    int  error = 0; 
    
    if(ds1820.begin()) {
        while(1) {
            ds1820.startConversion();  // start temperature conversion from analog to digital
            wait(1.0);                 // let DS1820 complete the temperature conversion 
            error = ds1820.read(temp); // read temperature from DS1820 and perform cyclic redundancy check (CRC)
            switch(error) {
            case 0:    // no errors -> 'temp' contains the value of measured temperature
                pc.printf("temp = %3.1f%cC\r\n", temp, 176);
                break;
            case 1:    // no sensor present -> 'temp' is not updated
                pc.printf("no sensor present\n\r");
                break;
            case 2:    // CRC error -> 'temp' is not updated
                pc.printf("CRC error\r\n");
            } 
            led = !led;
        }
    } else
        pc.printf("No DS1820 sensor found!\r\n");
}
 