#include "mbed.h"
#include "RawEthernet.h"

#define BUF_SIZE 100

uint8_t  len;
uint8_t  buf[BUF_SIZE];

// Ethernet settings
uint8_t  myMac[6] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06};     // MAC address of this slave device
uint8_t  myIp[4] = {192, 168, 1, 191};                        // Dummy IP used to tell LAN switches about the existence of this device
uint8_t  remoteMac[6] = {0x52, 0x4f, 0x47, 0x49, 0x45, 0x52}; // MAC oddress of the master PC

DigitalOut  led1(LED1);
RawEthernet rawEthernet(PB_5, PB_4, PB_3, PB_6, myMac, myIp); // mosi, miso, sck, cs

int main()
{
    rawEthernet.linkTo(remoteMac);

    while (true) {
        len = rawEthernet.receive(buf, BUF_SIZE);
        if (len != 0) {
            // toggle LED to acknowledge reception of data
            led1 = !led1;
            
            // do some stuff with data

            // in this test echo the received data to the sender           
            rawEthernet.send(buf, len);
        }
    }
}

