#include "mbed.h"
#include "math.h"
#include "Adafruit_GFX.h"
#include "TFT_ILI9163C.h"

#define M_PI 3.14159265358979323846


// Define TFT to NUCLEO_F446RE pin connection
#define TFT_MOSI    PA_7
#define TFT_SCLK    PA_5
#define TFT_CS      PB_6
#define TFT_DC      PC_7
#define TFT_RST     PA_9

// SPI speed
#define SPI_BITRATE 50000000L

// Color definitions
#define BLACK       0x0000
#define BLUE        0x001F
#define RED         0xF800
#define GREEN       0x07E0
#define CYAN        0x07FF
#define MAGENTA     0xF81F
#define YELLOW      0xFFE0
#define WHITE       0xFFFF

// Create display object
TFT_ILI9163C    display(TFT_MOSI, NC, TFT_SCLK, TFT_CS, TFT_DC, TFT_RST);
AnalogIn        a1(PA_0);
AnalogIn        a2(PA_1);
DigitalIn       startButton(PC_13);

int             bx = 64;
int             by = 64;
int             P1x1 = 0, P1x2 = 3, P1y1, P1y2;
int             P2x1 = 124, P2x2 = 127, P2y1, P2y2;
float           angle;
int             speed;
int             P1S = 0, P2S = 0;
int             hold, h1, h2;
char            score[32];

/**
 * @brief
 * @note
 * @param
 * @retval
 */
int main()
{
    //    display.text_width(1);
    //    display.text_height(1);
    //    display.baudrate(300000);
    // Initialize random angle between 0 and 360
    srand(time(NULL));
    do
    {
        angle = rand() % 361;
    } while
    (
        (angle < 20) ||
        (angle > 70 && angle < 110) ||
        (angle > 160 && angle < 200) ||
        (angle > 250 && angle < 290) ||
        (angle > 340)
    );

    /////////////////////////////////////////////////////
    while (1) {
        if (startButton == 0) {
            hold = 0;
            h1 = 0;
            h2 = 0;
        }

        if (hold == 1)
            speed = 0;
        else
            speed = 5;

        // Set position of the paddles
        P1y1 = (a1 * 103) + 8;
        P1y2 = P1y1 + 16;
        P2y1 = (a2 * 103 + 8);
        P2y2 = P2y1 + 16;

        // Control motion of ball
        display.fillCircle(bx, by, 2, WHITE);

        if ((bx > 122 && (by > P2y1 && by < P2y2)) || (bx < 5 && (by > P1y1 && by < P1y2)))
            angle = 180 - angle;
        else
        if (by > 125 || by < 10)    // I think this is where our problem is
            angle = -angle;

        //P1 Scores
        else
        if (bx > 122) {
            P1S++;
            bx = 5;
            by = P1y1 + 8;
            hold = 1;
            h1 = 1;
            angle = rand() % 120 + 120 + 180;

            //P2 Scores
        }
        else
        if (bx < 5) {
            P2S++;
            bx = 122;
            by = P2y1 + 8;
            hold = 1;
            h2 = 1;
            angle = rand() % 120 + 120;
        }

        if (hold == 1 && h1 == 1) {
            bx = 6;
            by = P1y1 + 8;
        }
        else
        if (hold == 1 && h2 == 1) {
            bx = 121;
            by = P2y1 + 8;
        }
        else {
            bx = bx + speed * cos(angle * 2 * M_PI / 360);
            by = by - speed * sin(angle * 2 * M_PI / 360);
        }

        // Print paddles and ball
        display.fillCircle(bx, by, 2, WHITE);
        display.fillRect(0, P1y1, 3, P1y2, WHITE);
        display.fillRect(124, P2y1, 127, P2y2, WHITE);
        display.fillRect(0, 9, 3, P1y1 - 1, 0);
        display.fillRect(0, P1y2 + 1, 3, 127, 0);
        display.fillRect(124, 9, 127, P2y1 - 1, 0);
        display.fillRect(124, P2y2 + 1, 127, 127, 0);
        display.fillRect(5, 8, 122, 8, WHITE);

        // Print scores
        display.setCursor(2, 0);

        //display.printf("P1: %d    P2: %d", P1S, P2S);
        sprintf(score, "P1: %d    P2: %d", P1S, P2S);
        display.print(score);
        wait(.005);
    }
}
