#ifndef MIDIKEY_H
#define MIDIKEY_H

#include "mbed.h"
#include "USBMIDI.h"

class MidiKey
{
public:
    MidiKey(USBMIDI& midi, uint8_t note, DigitalInOut& row, DigitalIn& col) :
        _midi(midi), _note(note), _row(row), _col(col), _position(0), _lastPos(0) {}
    virtual ~MidiKey() {}
    void scan();
private:
    USBMIDI&        _midi;
    uint8_t         _note;
    DigitalInOut&   _row;
    DigitalIn&      _col;
    uint8_t         _position;
    uint8_t         _lastPos;
};

#endif // MIDIKEY_H
