#include "stm32f103c8t6.h"
#include "mbed.h"
#include "MidiKey.h"

DigitalIn       a3(PA_3, PullDown);
DigitalIn       a4(PA_4, PullDown);
DigitalIn       a5(PA_5, PullDown);
DigitalIn       a6(PA_6, PullDown);
DigitalIn       a7(PA_7, PullDown);

DigitalInOut    a0(PA_0, PIN_INPUT, PullDown, 0);
DigitalInOut    a1(PA_1, PIN_INPUT, PullDown, 0);
DigitalInOut    a2(PA_2, PIN_INPUT, PullDown, 0);
DigitalInOut    b0(PB_0, PIN_INPUT, PullDown, 0);
DigitalInOut    b1(PB_1, PIN_INPUT, PullDown, 0);
DigitalInOut    b10(PB_10, PIN_INPUT, PullDown, 0);
DigitalInOut    b11(PB_11, PIN_INPUT, PullDown, 0);
DigitalInOut    c15(PC_15, PIN_INPUT, PullDown, 0);

/**
 * @brief
 * @note
 * @param
 * @retval
 */
int main()
{
    confSysClock();                 //Configure system clock (72MHz HSE clock, 48MHz USB clock)
    USBMIDI midi;
    MidiKey key[] =
    {
        MidiKey(midi, 53, a0, a5),  // S1
        MidiKey(midi, 54, a1, a5),  // S2
        MidiKey(midi, 55, a2, a5),  // S3
        MidiKey(midi, 56, b11, a5), // S4
        MidiKey(midi, 57, b10, a5), // S5
        MidiKey(midi, 58, b1, a5),  // S6
        MidiKey(midi, 59, b0, a5),  // S7
        MidiKey(midi, 60, c15, a6), // S8
        MidiKey(midi, 61, a0, a6),  // S9
        MidiKey(midi, 62, a1, a6),  // S10
        MidiKey(midi, 63, a2, a6),  // S11
        MidiKey(midi, 64, b11, a6), // S12
        MidiKey(midi, 65, b10, a6), // S13
        MidiKey(midi, 66, b1, a6),  // S14
        MidiKey(midi, 67, b0, a6),  // S15
        MidiKey(midi, 68, c15, a7), // S16
        MidiKey(midi, 69, a0, a7),  // S17
        MidiKey(midi, 70, a1, a7),  // S18
        MidiKey(midi, 71, a2, a7),  // S19
        MidiKey(midi, 72, b11, a7), // S20
        MidiKey(midi, 73, b10, a7), // S21
        MidiKey(midi, 74, b1, a7),  // S22
        MidiKey(midi, 75, b0, a7),  // S23
        MidiKey(midi, 76, c15, a4), // S24
        MidiKey(midi, 77, a0, a4),  // S25
        MidiKey(midi, 78, a1, a4),  // S26
        MidiKey(midi, 79, a2, a4),  // S27
        MidiKey(midi, 80, b11, a4), // S28
        MidiKey(midi, 81, b10, a4), // S29
        MidiKey(midi, 82, b1, a4),  // S30
        MidiKey(midi, 83, b0, a4),  // S31
        MidiKey(midi, 84, c15, a3)  // S32
    };
    size_t  keyLen = sizeof(key) / sizeof(*key);

    while (1) {
        for (uint8_t i = 0; i < keyLen; i++) {
            key[i].scan();
            wait_ms(2);
        }
    }
}
