#include "MapleMini.h"
#include "mbed.h"
#include "USBSerial.h"

DigitalOut  myled(LED1);
DigitalOut  usbEn(PB_9);    //Used for connecting/disconnecting the 1k5 resistor to/from the USB DP pin

int main() {
    confSysClock();         //Configure system clock (72MHz HSE clock, 48MHz USB clock)
    
    Serial      pc(PA_2, PA_3);
    USBSerial   usbSerial;
    
    usbEn = 0;              //Keep the on-board 1k5 resistor connected to the USB DP pin
    
    while(1) {
        myled = !myled;
        pc.printf("I am a serial port\r\n");            // 9600 bit/s
        usbSerial.printf("I am a USB serial port\r\n"); // 12 Mbit/s (USB full-speed)
        wait_ms(1000);
    }
}
