#include "mbed.h"
#include "Manchester.h"
#include "CRC16.h"

DigitalOut      led(LED1);
Manchester      man(p11, p12, 9600);    // Tx pin, Rx pin, speed [bps]
ManchesterMsg   msg(255);               // Message container (max bytes)
CRC16           crc16;                  // CRC16 object

int main(void) {
    man.setPreamble(5);                             // Number of sync pulses in preamble
    while(1) {
        msg.clear();                                // Clear the message
        msg << "Hello World!" << 0xfa74c309;        // Add some data to the message
        msg << crc16.calc(msg.data, msg.len);       // Append CRC16 to the message
        man.transmit(msg);                          // Transmit the message
        wait_ms(1000);
        led = !led;
    }
}

