#include "mbed.h"
#include "Manchester.h"
#include "CRC16.h"

DigitalOut      led(LED1);
Manchester      man(D3, D4, 9600);    // Tx pin, Rx pin, speed [bps]
ManchesterMsg   msg(100);               // Message container (max bytes)
char            str[80];                // Storage for the received array of char
uint32_t        val;                    // Storage for the value received
CRC16           crc16;                  // CRC16 object
unsigned short  recvCRC16;              // CRC16 received in the message
unsigned short  calcCRC16;              // CRC16 calculated

int main(void) {
    man.setPreamble(5);                 // Number of sync pulses in preamble
    while(1) {
        if(man.receive(msg)) {          // Receive message
            
            // Print data length and raw data bytes
            printf("\r\n----------------------------------------\r\n");
            printf("Message length = %d, Raw data :\r\n", msg.len);
            for(size_t i = 0; i < msg.len; i++) {
                if((i + 1) % 10 == 0)
                    printf("  %.2x\r\n", msg.data[i]);
                else
                    printf("  %.2x", msg.data[i]);
            }
            printf("\r\n\r\n");
            
            // Calculate CRC16. Exclude CRC bytes (last two bytes) from calculation.
            calcCRC16 = crc16.calc(msg.data, msg.len - 2);            
            printf("Calculated CRC16 = %d\r\n", calcCRC16);
            
            // Extract data and CRC16 from the message
            msg >> str >> val >> recvCRC16;
            
            printf("Received   CRC16 = %d\r\n", recvCRC16);
            printf("\r\n");           
 
            if( calcCRC16 == recvCRC16) {
                printf("Received data :\r\n");
                printf("  str = %s\r\n", str);
                printf("  val = 0x%x\r\n", val);
            }
            else
                printf("CRC error\r\n");
        }
        else
            printf("Error\r\n");

        led = !led;
    }
}
