#include "mbed.h"
#include "ManchesterUART.h"
#include "CRC16.h"

static ManchesterUART   man(D8, D2, 115200);    // Tx pin name, Rx pin name, speed [bps]
static ManchesterMsg    msg(256);               // Message container (max bytes)
static CRC16            crc16;                  // CRC16 object
static DigitalOut       led(LED1);

/**
 * @brief
 * @note
 * @param
 * @retval
 */
int main(void)
{
    man.setPreamble(20);                        // Set number of start patterns
    while (1)
    {
        msg.clear();                            // Clear the message
        msg << 0xfa74c309;                      // Add some binary data to the message
        msg << "Hello, World!";                 // Add some string to the message
        msg << crc16.calc(msg.data, msg.len);   // Append CRC16 to the message
        man.transmit(msg);                      // Transmit the message
        led = !led;
        wait_ms(1000);
    }
}

