#include "mbed.h"
#include "ManchesterUART.h"
#include "CRC16.h"

static DigitalOut       led(LED1);
static ManchesterUART   man(p28, p27, 115200);  // Tx pin name, Rx pin name, speed [bps]
static ManchesterMsg    msg(256);               // Message container (max bytes)
static char             str[256];               // Storage for the received array of char
static uint32_t         binaryData;             // Storage for the binary data received
static CRC16            crc16;                  // CRC16 object
static unsigned short   recvCRC16;              // CRC16 received with the message
static unsigned short   calcCRC16;              // CRC16 calculated

/**
 * @brief
 * @note
 * @param
 * @retval
 */
int main(void)
{
    while (1)
    {
        if (man.receive(msg))   // Receive message
        {
            // Print data length and raw data bytes
            printf("\r\n----------------------------------------\r\n");
            printf("Message length: %d\r\n", msg.len);
            printf("Raw data :\r\n");
            for (size_t i = 0; i < msg.len; i++)
            {
                if ((i + 1) % 10 == 0)
                    printf("  %.2X\r\n", msg.data[i]);
                else
                    printf("  %.2X", msg.data[i]);
            }

            printf("\r\n");

            // Calculate CRC16. Exclude CRC bytes (last two bytes) from calculation.
            calcCRC16 = crc16.calc(msg.data, msg.len - 2);
            //printf("Calculated CRC16 = %d\r\n", calcCRC16);
            
            //Extract data and CRC16 from the message
            msg >> binaryData >> str >> recvCRC16;
            
            //printf("Received   CRC16 = %d\r\n", recvCRC16);
            printf("\r\n");

            if (calcCRC16 == recvCRC16)
            {
                printf("Decoded data :\r\n");
                printf("  binary = 0x%lX\r\n", binaryData);
                printf("  string = %s\r\n", str);
            }
            else
                printf("CRC error\r\n");

            led = !led;
        }
    }
}
