#include "MapleMini.h"
#include "mbed.h"
#include "USBKeyboard.h"

#define POS_MIN 20000
#define POS_MAX 50000

DigitalOut      led(PB_1);                  // LED
DigitalOut      usbEn(PB_9);                // Used for connecting/disconnecting the 1k5 resistor to/from the USB DP pin
AnalogIn        vRx(PB_0);                  // Joystick Rx pin
AnalogIn        vRy(PA_7);                  // Joystick Ry pin
DigitalIn       btnCtrl(PB_12, PullDown);   // Ctrl key
DigitalIn       btnShift(PB_14 , PullDown); // Shift key
DigitalIn       btnUp(PA_10, PullDown);     // PageUp key (Z-up)
DigitalIn       btnDown(PA_1, PullDown);    // PageDown key (Z-down)
uint8_t         modifier = 0;
USBKeyboard*    keyboard;

/**
 * @brief
 * @note
 * @param
 * @retval
 */
int main()
{
    confSysClock(); //Configure system clock (72MHz HSE clock, 48MHz USB clock)
    led = 1;
    keyboard = new USBKeyboard();
    usbEn = 0;      //Keep the on-board 1k5 resistor connected to USB DP pin
    while (1) {
        if (btnShift == 1) {
            modifier = KEY_SHIFT;
        }
        else
        if (btnCtrl == 1) {
            modifier = KEY_CTRL;
        }
        else {
            modifier = 0;
        }

        if (vRy.read_u16() < POS_MIN) {
            keyboard->keyCode(LEFT_ARROW, modifier, false);
        }
        else
        if (vRy.read_u16() > POS_MAX) {
            keyboard->keyCode(RIGHT_ARROW, modifier, false);
        }
        else
        if (vRx.read_u16() < POS_MIN) {
            keyboard->keyCode(DOWN_ARROW, modifier, false);
        }
        else
        if (vRx.read_u16() > POS_MAX) {
            keyboard->keyCode(UP_ARROW, modifier, false);
        }
        else
        if (btnUp == 1) {
            keyboard->keyCode(KEY_PAGE_UP, modifier, false);
        }
        else
        if (btnDown == 1) {
            keyboard->keyCode(KEY_PAGE_DOWN, modifier, false);
        }
        else {
            keyboard->keyCode(0, 0);    // Release the key(s)
        }
    }
}
