#include "mbed.h"
#include "HX711.h"
#include "HMC1501.h"

//
DigitalOut      led1(LED1);
HX711           hx711(3.2f, D2, D3, 32);    // avdd in Volts, sck pin, dout pin, gain
HMC1501         hmc1501(-35.5, 47.05);      // minV [mV], maxV [mV]: measured by rotating a magnet in front of the chip
Ticker          ticker;
volatile bool   tick = false;
//

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void onTick()
{
    tick = true;
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
int main()
{
    printf("Starting...\r\n");
    ticker.attach_us(onTick, 1000 * 1000);   // 500ms
    hx711.powerUp();
    while (true) {
        if (tick) {
            tick = false;
            led1 = !led1;
            if (hx711.isReady()) {
                float mV = hx711.read();    // read voltage in mV
                printf("hx711 voltage \t= %fmV\r\n", mV);
                printf("hmc1501 offset \t= %f mV\r\n", hmc1501.getOffset());
                printf("hmc1501 angle \t= %f deg\r\n", hmc1501.angle(mV));
                printf("-------------------------------------------\r\n");
            }
        }
    }
}
