/*
 * Copyright (c) 2020 Zoltan Hudak <hudakz@outlook.com>
 * All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _HMC1501_H_
#define _HMC1501_H_
#include "mbed.h"

/**
 * A class to work with a HMC1501 magnetic angular sensor.
 */
class   HMC1501
{
public:
    /**
     * Creates an HMC1501 object
     * @param minV  Minimum voltage measured in mV when rotating a magnet.
     * @param maxV  Maximum voltage measured in mV when rotating a magnet.
     */
    HMC1501(float minV, float maxV);

    /**
     * @brief   Amplitude in mV
     * @note    Ampliture is equal to the half of peak-to-peak calculated from minV, maxV
     * @retval  Amplitude in mV
     */
    float   getAmplitude()  { return _amplitude; }

    /**
     * @brief   Offset in mV
     * @note    Input offset calculated from minV, maxV
     * @retval  Offset in mV
     */
    float   getOffset()     { return _offset; }

    /**
     * @brief   Angle in degree [°]
     * @note    theta = arcsin(Volt) / 2 [rad]
     * @param   Input voltage in mV
     * @retval  Angle in degree [°]
     */
    float   angle(float mV);
private:
    float   _amplitude; // [mV]
    float   _offset;    // [mV]
};
#endif
