/*
 * Copyright (c) 2020 Zoltan Hudak <hudakz@outlook.com>
 * All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "HMC1501.h"
#include "math.h"

#define M_PI        3.14159265358979323846

/**
 * @brief   Creates a HMC1501 object
 * @note    Minimum and maximum voltages shall be measured by rotating the magnet
 * @param   minV    Minimum voltage [mV]
 * @param   maxV    Maximum voltage [mV]
 */
HMC1501::HMC1501(float minV, float maxV)
{
    float peakToPeak = maxV - minV;
    float halfPeakToPeak = peakToPeak / 2;
    _amplitude = halfPeakToPeak;
    _offset = maxV - halfPeakToPeak;
}

/**
 * @brief   Angle in degree [°]
 * @note    theta = arcsin(Volt) / 2 [rad]
 * @param   Input voltage in mV [mV]
 * @retval  Angle in degree [°]
 */
float HMC1501::angle(float mV)
{
    float sinus = (mV - _offset) / _amplitude;

    return (asin(sinus) * 180) / M_PI / 2;
}
