#ifndef ENIGMA_H
#define ENIGMA_H

#include "mbed.h"


class   Enigma
{
    size_t   _len;
    uint32_t _seed;
    uint8_t  _entryWheel[256];
    uint8_t* _rightRotor;
    uint8_t* _middleRotor;
    uint8_t* _leftRotor;
    uint8_t* _reflector;
    uint8_t  _leftRotorPos;
    uint8_t  _middleRotorPos;
    uint8_t  _rightRotorPos;
    uint8_t (*_plugboard)[2];
    uint8_t  _cords;

    size_t _mod(long i);
    int    _find(uint8_t byte, uint8_t* array);
public:
    static const uint8_t ROTOR_I[256];
    static const uint8_t ROTOR_II[256];
    static const uint8_t ROTOR_III[256];
    static const uint8_t ROTOR_IV[256];
    static const uint8_t ROTOR_V[256];
    static const uint8_t REFLECTOR[256];

    // Constructor
    Enigma
    (
        const uint8_t*  leftRotorSel,
        const uint8_t*  middleRotorSel,
        const uint8_t*  rightRotorSel,
        uint8_t         leftRotorPos,
        uint8_t         middleRotorPos,
        uint8_t         rightRotorPos,
        uint8_t         (*plugboard)[2],
        uint8_t         cords
    );

    // Methods
    uint8_t* encrypt(uint8_t* out, const uint8_t* in, size_t len);
    uint8_t* decrypt(uint8_t* out, const uint8_t* in, size_t len);

    // Helpers
    void   genRotorWiring(const char* name, unsigned seed);
    void   genReflectorWiring(unsigned seed);
};
#endif // ENIGMA_H
