# mbed OS Ethernet MAC (EMAC) driver for the ENC28J60 Ethernet controller
  and modules equipped with such chip.

This is a fork (simplified version) of the ENC28J60-EMAC driver published by Tobias Jaster at

https://github.com/tobiasjaster/ENC28J60-EMAC-Driver

Usage:

1.  Connect the ENC28J60 module to the Mbed board as follows:


    -------------      SPI interface     --------------
                 |                      |
            MOSI |----------------------| MOSI
                 |                      |
            MISO |----------------------| MISO
    Mbed         |                      |       ENC28J60
    board   SCK  |----------------------| SCK   module
                 |                      |
            CS   |----------------------| CS
                 |                      |
            GND  |----------------------| GND
                 |                      |
    -------------                        --------------

2.  Import (add) this ENC28J60-EMAC library to your program.

3.  Add a "mbed_app.json" file with the following content
    to the root directory of your program:

    {
        "target_overrides": {
            "*": {
                "platform.callback-nontrivial": true,
                "enc28j60-emac.mosi":  "D11",
                "enc28j60-emac.miso":  "D12",
                "enc28j60-emac.sck" :  "D13",
                "enc28j60-emac.cs"  :  "D10"
            }
        }
    }

   Replace "D11", ... with the actual pin names you selected on the Mbed board
   to be used for the SPI communication.

4. To set the MAC address define an array with the desired address bytes and
   call the "set_hwaddr(mac)" function before calling the network interface "connect" function.

   For example:

    const uint8_t       MAC[6] = { 0, 1, 2, 3, 4, 5 };
    EthernetInterface   net;

    int main()
    {
        net.get_emac().set_hwaddr(MAC);             // set MAC address
        if (net.connect() != 0) {
            printf("Error: Unable to connect to the network.\n");
            return -1;
        }

        ...

