/*
 * This is a fork of the CRC16 library COPYRIGHT(c) Emilie Laverge
 * published at [https://developer.mbed.org/users/EmLa/code/CRC16/]
 *
 * Modified by Zoltan Hudak to implement CRC16-CCITT
 * using the polynomial 0x1021: X^16 + X^15 + X^2 + 1.
 * Default initial CRC value = 0x0000
 */

#ifndef CRC16_CCITT_H
#define CRC16_CCITT_H

class   CRC16_CCITT
{
private:
    static const unsigned int   SHIFTER;
    static const unsigned short TABLE[];
public:
    CRC16_CCITT(void){};
    ~CRC16_CCITT(void){};
    unsigned short calc(char input[], int length, unsigned short crc = 0x0000);
};

#endif // CRC16_CCITT_H
