#ifndef ANALOGINCAL_H
#define ANALOGINCAL_H

/* Analog input with AD converter calibration for STM32F1 and STM32F3 boards.
 *
 * Substitutes AnalogIn.
 *
 */

#include "AnalogIn.h"

class AnalogInCal : public AnalogIn
{
public:

    /** Creates an AnalogInCal, connected to the specified pin
     *
     * @param pin AnalogIn pin to connect to
     * @param cal Flag to request calibration. Defaults to true.
     */
    AnalogInCal(PinName pin, bool cal = true) : AnalogIn(pin) {
        if (cal)
            calibrate();
    }

    /** Calibrates the associated AD Convertor
     *
     */
    void calibrate()  {
        lock();
#if defined(TARGET_STM32F1)
        while (HAL_ADCEx_Calibration_Start(&(_adc.handle)) != HAL_OK);
#elif defined(TARGET_STM32F3)
        while (HAL_ADCEx_Calibration_Start(&(_adc.handle), ADC_SINGLE_ENDED) != HAL_OK);
#endif
        unlock();
    }
};

#endif // ANALOGINCAL_H
