#include "mbed.h"
#include "BufferedSerial.h"
#include "YDLidarX4.h"

#define PC_TX USBTX
#define PC_RX USBRX
#define PC_BAUD 115200

#define LIDAR_TX PA_9
#define LIDAR_RX PA_10
#define LIDAR_M_EN PB_5
#define LIDAR_M_PWN PB_4
#define LIDAR_DEV_EN PA_11

#define ALPHA 0.70
#define BETA 0.85
//각도/거리보정 계수

BufferedSerial pc(PC_TX, PC_RX, 512);
YDLidarX4 lidar(LIDAR_TX, LIDAR_RX, LIDAR_M_EN, LIDAR_M_PWN);

uint16_t samples[128];
uint16_t trend[360];
uint16_t datas[360];
//samples와 trend는 각도보정에 쓰이는 거리값, datas는 sample과 trend에 의해 보정된 거리값

bool isSampling = false;
/*샘플링되었는가?*/

void processInput() {
    // Si il y a un message sur le port série
    // 직렬포트에 메세지가 있는 경우
    // pc로부터 명령어 받았을때 상황
    if (pc.readable()) {
        switch(pc.getc()) {
            //메세지의 종류에 따른 분류
            //여기까지 작동 확인
            case 'G': { // Derniers points relevés
            //최종점수? 아무튼 pc로부터 받은 값이 'G'일때
                uint32_t sum = 0;
                uint8_t sum_counter = 0;
                uint8_t counter = 0;
                uint8_t degree = 0;
                //값들 초기화
                
                // On envoit sur le port série la moyenne tous les 10 degrés
                // 10도마다 직렬포트로 평균치를 보낸다.
                for (uint16_t index = 0; index < 360; index++) {
                    // 이 if문은 datas 배열의 index에 해당하는 값을 sum 변수에 더한다.
                    if (datas[359 - index] != 0) {
                        //datas라는 배열의 우측 데이터부터 0이 아니라면
                        sum += datas[359 - index];
                        //sum이라는 변수는 datas 배열의 index에 해당하는 데이터를 더한다.
                        sum_counter += 1;
                        //sum이 몇번 더해졌는지 판별하기 위한 index?
                    }
                    if (++counter == 1) {
                        //***************************************************************************평균치 개수 여기서 조절
                        pc.printf("%d:", sum / sum_counter);
                        counter = 0;
                        sum = 0;
                        sum_counter = 0;
                        // counter가 10이면 sum을 10으로 나눈 평균치를 출력하고 모든 변수값 초기화.
                        // 0~9 평균 출력 및 초기화, 10~11 평균 출력 및 초기화,....
                        // counter == x 값 변경
                    }
                }
                pc.printf("\n");
                break;
            };
            case 'I': { // Information d'identification
            // 'I'일 경우 식별정보 pc로 출력. 아마 기기정보인듯
            // 근데 아무 명령어가 없다?
                pc.printf("CarteLidar\n");
                break;
            };
            case 'R': { // soft reset du LIDAR
            // 'R'일 경우 Lidar의 소프트 리셋
                lidar.softReset();
                pc.printf("softReset\n");
                break;
            };
            case 'E': { // Démarrer le ranging
            /*
            
            ***************************************************************************'E' 입력시 감지 시작
            isSampling을 True로 만들어주는게 끝이긴 하다
            
            */
            pc.printf("entering E ok\n");
                if (lidar.startSampling()) {
                    isSampling = true;
                    //샘플링 시작 선언
                    pc.printf("1\n");
                } else {
                    pc.printf("0\n");
                }
                break;
            };
            case 'D': { // Arrêter le ranging
            //'D'입력시 감지 중지
                lidar.stopSampling();
                isSampling = false;
                pc.printf("sampling stop\n");
                break;
                
            case 'O':{
                lidar.stopplease();
                pc.printf("stop ok\n");
                break;
                }
            };
            case 'S': { // Savoir si le lidar est entrain de fonctionner ou non
            //'S'입력시 LIdar가 작동중인지 여부 확인.
            //isSampling 변수를 통해 확인한다.
                pc.printf(isSampling ? "State Sampling\n" : "State Stop\n");
            }
        }
    }
}

void format_samples(uint8_t size) {
    // Formate les distances obtenues suivant les indications du datasheet
    //데이터시트 지시사항에 따라 얻은 거리를 측정한다
    for (uint8_t index = 0; index < size; index++) {
        samples[index] = samples[index] / 4.0;
    }
}

double get_angle_correct(double distance) {
    // Calcule la correction de l'angle suivant les indications du datasheet
    //데이터시트 지시사항에 따라 얻은 각도보정
    return distance == 0 ? 0 : atan(21.8 * (155.3 - distance) / (155.3 * distance)) * 57.2957795147;
}

uint16_t get_angle_formated(int16_t angle) {
    // Permet d'obtenir un angle module 360
    // 각도가 0도 미만 또는 360도 이상일때 보정
    return angle < 0 ? angle + 360 : angle > 360 ? angle - 360 : angle;
}

int main() {
    // Initialisation des communications UART
    //UART 통신 초기화
    pc.baud(PC_BAUD);
    
    int angle;
    int s;
    int index;
    


    // Boucle infinie
    // 반복문
    
    while (true) {
        // Si le ranging est actif, on lit le prochain paquet
        // 감지가 활성화된 경우 다음 패킷을 읽는다
        if (isSampling) {
            // 이 반복문은 isSampling이 활성화된 경우, 즉 감지 명령어 'E'가 들어온 경우에만 실행된다
            cloudHeader header;
            /*
    
            pc.printf("cloudHeader\n");
            
            */
            // Récupération du paquet de points actuel
            // 현재 포인트 패킷 복구
            lidar.getCloudHeader(&header);
            /*
            
            pc.printf("getCloudHeader\n");
        
            */
            lidar.getCloudSamples(samples, header.lsn);
            /*
            
            pc.printf("getCloudSample\n");
            
            */
            // Si il y a au moins un point échantilloné
            // 하나 이상의 샘플링 지점이 있는 경우
            if (header.lsn > 1) {
                // Formatage préliminaire des points
                // 점의 예비 포맷
                format_samples(header.lsn);
                // Calcul des angles initiaux et finaux du paquet
                //패킷의 초기 및 최종 각도 계산
                double fsa = ((double)(header.fsa >> 1) / 64.0) + get_angle_correct(samples[0]);
                double lsa = ((double)(header.lsa >> 1) / 64.0) + get_angle_correct(samples[header.lsn - 1]);
                double dif = fsa < lsa ? (lsa - fsa) / ((double)header.lsn - 1.0) : (360.0 + lsa - fsa) / ((double)header.lsn - 1.0);
                // Iteration sur chaque point du paquet
                for (index = 0; index < header.lsn; index++) {
                    // Si la distance mesurée est positive
                    // 측정된 거리가 양수인 경우
                    if (samples[index] != 0) {
                        // Détermination de l'angle pour le point courant
                        //현재 지점에 대한 각도 결정
                        angle = get_angle_formated(((dif * (double)(index)) + fsa + get_angle_correct(samples[index])));
                        // Lissage à double exponentielle de la mesure
                        // 이중 지수 측정 평활화
                        s = ALPHA * (double)samples[index] + (1.0 - ALPHA) * ((double)datas[angle] + (double)trend[angle]);
                        trend[angle] = BETA * ((double)s - (double)datas[angle]) + (1.0 - BETA) * (double)trend[angle];
                        // Stockage du résultat
                        // 결과 저장
                        datas[angle] = s;
                    }
                }
            }
        }
        // On exécute les commandes reçues
        // 수신된 명령을 실행
        // comportMaster에서 내가 보낸 명령어는 while문 맨 끝에서 받게된다.
        // while문의 코드는 감지명령이 있을때만 실행되는데 감지명령만 들어가면 먹통되는걸 보면 while문을 빠져나오지 못하는걸로 예상
        processInput();
    }
}