#ifndef YDLIDARX4_H
#define YDLIDARX4_H

#include "BufferedSerial.h"
#include "mbed.h"

#define LIDAR_BAUD 128000

#define RESPONSE_HEADER_BYTE_1 0xA5
#define RESPONSE_HEADER_BYTE_2 0x5A
#define RESPONSE_HEADER_TYPE_START 0x81
// Scan Command

#define CLOUD_HEADER_BYTE_1 0xAA
#define CLOUD_HEADER_BYTE_2 0x55
// 2B in length, fixed at 0x55AA, low in front, high in back

#define START_BYTE 0xA5
#define CMD_START 0x60
#define CMD_STOP 0x65
#define CMD_RESET 0x80
#define CMD_HEALTH 0x91
// System Command

struct responseHeader {
    //응답 관련 헤더
    uint8_t startByte1;
    uint8_t startByte2;
    //start sign, 16비트인데 2개로 나눠놓은듯 
    uint32_t length:30;
    //length 30비트
    uint32_t mode:2;
    //mode 2비트
    uint8_t type;
    //타입코드, 개발자메뉴얼에 8비트라 명시
} __attribute__((packed));


struct cloudHeader {
    //패킷
    uint16_t ph;
    // 패킷헤더
    uint8_t ct;
    // 패키지 타입
    uint8_t lsn;
    // 수신 정보량
    uint16_t fsa;
    // first
    uint16_t lsa;
    // last
    uint16_t cs;
    // check sum
} __attribute__((packed));


class YDLidarX4 {

public:

    YDLidarX4(PinName tx, PinName rx, PinName m_en, PinName ctl);

    void stopplease();
    //좀 멈추게 만들어본거
    void softReset();
    int startSampling();
    void stopSampling();
    // 단순명령어들, 따로 입력값이 없다.
    
    void setRotationSpeed(float speed);
    void getResponseHeader(responseHeader* header);
    void getCloudHeader(cloudHeader* header);
    void getCloudSamples(uint16_t* tab, uint8_t size);

private :

    void sendCommand(uint8_t com);
    void flush();

    BufferedSerial _lidar;
    DigitalOut _m_en;
    PwmOut _m_ctl;

};

#endif
